# Copyediting

1. [Orientation](copyediting#orientation)
1. [Editorial Actions](copyediting#editorial-actions)

During the Copyediting stage, the editor assigns a copyeditor to edit the submission files.

The copyeditor, who is often a professional, will align the writing style with your editorial guidelines, improve the quality and clarity of the writing, fix any grammar, and get the submission ready for conversion to a [publication format](production).

This is the last stage before you generate publication-ready formats such as PDFs and ePubs. If you do not have the resources to hire a professional copyeditor, use this stage to take a close look at the material, check any facts, correct any errors, and communicate with the author to clarify any points of confusion.

Add copyeditors from the [participants panel](../editorial-workflow#participants).
For more detailed information, see [Learning OJS 3: Copyediting](https://docs.pkp.sfu.ca/learning-ojs/en/editorial-workflow#copyediting).

## <a name="orientation"></a>Orientation

The Copyediting stage provides three panels for managing the copyediting process.

### <a name="draft-files"></a>Draft Files

All files selected by the editor for copyediting. These are typically files that have been revised as a result of the review process.

### <a name="copyediting-discussions"></a>Copyediting Discussions

Editors and copyeditors can use this panel to initiate discussions with the author(s) or communicate among themselves. This can be used to clarify points of confusion, request further information from the author, or request approval for any changes.

### <a name="copyedited"></a>Copyedited

Copyeditors can upload final edited files to this panel. These should be completed files that are ready to be [sent to production](copyediting#editorial-actions).

*Editors can upload files here, too.*

### <a name="participants"></a>Participants

Editors can add copyeditors from this panel. [Learn more](../editorial-workflow#participants).

## <a name="editorial-actions"></a>Editorial Actions

There's only one editorial decision available to editors at this stage. If you decide to decline a submission at this late stage, you can do so by going back to a previous stage.

### <a name="production"></a>Send to Production

The editor can send the submission to the [Production stage](production) when final copyedited files are ready. Any files in the [Copyedited](copyediting#copyedited) panel will automatically be forwarded unless the editor chooses not to send them.
